<?php
include 'koneksi.php';

// Ambil semua data rating
$data = [];
$result = $conn->query("SELECT * FROM ratingss");
while ($row = $result->fetch_assoc()) {
    $data[$row['user_id']] = [
        'Interstellar' => $row['interstellar'],
        'Inception' => $row['inception'],
        'Titanic' => $row['titanic'],
        'Avatar' => $row['avatar'],
        'Matrix' => $row['matrix']
    ];
}

// Fungsi cosine similarity antar dua film
function cosine_similarity($item1, $item2, $data) {
    $dot = 0; $norm1 = 0; $norm2 = 0;
    foreach ($data as $ratings) {
        if ($ratings[$item1] > 0 && $ratings[$item2] > 0) {
            $a = $ratings[$item1];
            $b = $ratings[$item2];
            $dot += $a * $b;
            $norm1 += $a * $a;
            $norm2 += $b * $b;
        }
    }
    if ($norm1 == 0 || $norm2 == 0) return 0;
    return $dot / (sqrt($norm1) * sqrt($norm2));
}

// Prediksi rating U6 terhadap Titanic
$u6 = $data['U6'];
$items = ['Interstellar', 'Inception', 'Avatar', 'Matrix'];
$numerator = 0;
$denominator = 0;

foreach ($items as $item) {
    $sim = cosine_similarity('Titanic', $item, $data);
    $rating = $u6[$item];
    $numerator += $sim * $rating;
    $denominator += abs($sim);
}
$prediksi = ($denominator != 0) ? $numerator / $denominator : 0;
?>

<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8">
  <title>Prediksi Rating Film</title>
  <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet">
  <style>
    * {
      margin: 0;
      padding: 0;
      box-sizing: border-box;
    }

    body {
      font-family: 'Poppins', sans-serif;
      background: linear-gradient(to right top, #141e30, #243b55);
      color: #f0f0f0;
      padding: 40px 20px;
    }

    .container {
      max-width: 960px;
      margin: auto;
      display: flex;
      flex-direction: column;
      gap: 24px;
    }

    .card {
      background: rgba(255, 255, 255, 0.05);
      border-radius: 20px;
      padding: 24px;
      box-shadow: 0 8px 24px rgba(0,0,0,0.2);
      backdrop-filter: blur(10px);
      border: 1px solid rgba(255,255,255,0.1);
    }

    h2, h3, h4 {
      color: #ffcc00;
      margin-bottom: 12px;
    }

    .highlight {
      font-size: 2rem;
      font-weight: bold;
      color: #00ffc8;
      margin-top: 10px;
    }

    table {
      width: 100%;
      border-collapse: collapse;
      background: rgba(255,255,255,0.03);
      border-radius: 10px;
      overflow: hidden;
    }

    th, td {
      padding: 12px;
      text-align: center;
      border: 1px solid rgba(255,255,255,0.1);
    }

    th {
      background-color: rgba(255,255,255,0.07);
      font-weight: 600;
    }

    pre {
      background: rgba(255,255,255,0.05);
      padding: 16px;
      border-radius: 10px;
      overflow-x: auto;
    }

    .identitas-wrapper {
      display: flex;
      flex-wrap: wrap;
      align-items: center;
      justify-content: space-between;
      gap: 20px;
    }

    .identitas-foto img {
      width: 120px;
      border-radius: 12px;
      box-shadow: 0 0 10px rgba(255,255,255,0.4);
    }

    @media (max-width: 600px) {
      .identitas-wrapper {
        flex-direction: row; /* tetap row meskipun layar kecil */
        justify-content: space-between;
        align-items: center;
      }
    }
    .math-container {
        overflow-x: auto;
        max-width: 100%;
        padding-bottom: 8px;
    }
    .math-container::-webkit-scrollbar {
        height: 6px;
    }
    .math-container::-webkit-scrollbar-thumb {
        background: rgba(255,255,255,0.3);
        border-radius: 3px;
    }

  </style>
</head>
<body>
  <div class="container">

    <div class="card identitas">
      <div class="identitas-wrapper">
        <div>
          <h2>Identitas Mahasiswa</h2>
          <p>
            <strong>NIM:</strong> 2302050856<br>
            <strong>Nama:</strong> Laila Nur Aulia<br>
            <strong>Prodi:</strong> Sistem Informasi<br>
            <strong>Kelas:</strong> SI-A
          </p>
        </div>
        <div class="identitas-foto">
          <img src="foto.jpg" alt="Foto Mahasiswa">
        </div>
      </div>
    </div>

    <div class="card">
      <h3>Data Rating Film</h3>
      <table>
        <tr>
          <th>User</th>
          <th>Interstellar</th>
          <th>Inception</th>
          <th>Titanic</th>
          <th>Avatar</th>
          <th>Matrix</th>
        </tr>
        <?php foreach ($data as $user => $rating): ?>
        <tr>
          <td><?= $user ?></td>
          <td><?= $rating['Interstellar'] ?></td>
          <td><?= $rating['Inception'] ?></td>
          <td><?= $rating['Titanic'] ?></td>
          <td><?= $rating['Avatar'] ?></td>
          <td><?= $rating['Matrix'] ?></td>
        </tr>
        <?php endforeach; ?>
      </table>
    </div>

    <div class="card">
      <h3>Hasil Prediksi</h3>
      <p>Prediksi rating <strong>U6</strong> terhadap <strong>Titanic</strong> (Item-Based Collaborative Filtering):</p>
      <div class="highlight"><?= round($prediksi, 2) ?></div>
    </div>

    <div class="card">
      <h3>Penjelasan Metode</h3>
      <p><strong>Item-Based Collaborative Filtering</strong> memprediksi rating dengan menghitung kemiripan antar item.</p>
      <h3>Rumus Prediksi</h3>
  <p>Dengan metode <strong>Item-Based Collaborative Filtering</strong>, rumus prediksi rating U6 terhadap <em>Titanic</em> adalah:</p>
  <p style="font-size: 1.2rem;">
    $$ 
    \hat{r}_{U6, \text{Titanic}} = \frac{
    \sum_{i \in I} \text{sim}(\text{Titanic}, i) \cdot r_{U6,i}
    }{
    \sum_{i \in I} |\text{sim}(\text{Titanic}, i)|
    }
    $$
  </p>

  <p>Contoh dalam kasus:</p>
  <div class="math-container">
  $$
  \hat{r}_{U6, \text{Titanic}} = \frac{
    \text{sim}(T, I) \cdot r_{U6, I} + 
    \text{sim}(T, N) \cdot r_{U6, N} + 
    \text{sim}(T, A) \cdot r_{U6, A} + 
    \text{sim}(T, M) \cdot r_{U6, M}
  }{
    |\text{sim}(T, I)| + 
    |\text{sim}(T, N)| + 
    |\text{sim}(T, A)| + 
    |\text{sim}(T, M)|
  }
  $$
</div>


    </div>

  </div>
</body>
</html>


<script src="https://polyfill.io/v3/polyfill.min.js?features=es6"></script>
<script id="MathJax-script" async
  src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-mml-chtml.js">
</script>
